/*
 * Decompiled with CFR 0.152.
 */
package com.robocraft999.creategoggles.neoforge;

import com.robocraft999.creategoggles.CGConfig;
import com.robocraft999.creategoggles.CreateGoggles;
import com.robocraft999.creategoggles.neoforge.compat.mekanism.CompatMekanism;
import com.robocraft999.creategoggles.neoforge.data.RecipeDataProvider;
import com.robocraft999.creategoggles.neoforge.registry.CGItemsNeoforge;
import com.robocraft999.creategoggles.neoforge.registry.CGModules;
import com.robocraft999.creategoggles.registry.ModCompat;
import mekanism.api.MekanismIMC;
import net.minecraft.core.Holder;
import net.minecraft.data.DataProvider;
import net.minecraft.world.item.CreativeModeTabs;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="creategoggles")
public class CreateGogglesNeoforge {
    public static final Logger logger = LogManager.getLogger((String)"creategoggles");

    public CreateGogglesNeoforge(ModContainer container) {
        CreateGoggles.REGISTRATE.defaultCreativeTab(CreativeModeTabs.COMBAT);
        CreateGoggles.init();
        CreateGoggles.LOGGER.info("CreateGogglesForge init");
        IEventBus modEventBus = container.getEventBus();
        CreateGoggles.REGISTRATE.registerEventListeners(modEventBus);
        if (ModCompat.MEKANISM.isLoaded()) {
            CGItemsNeoforge.register();
            CGModules.register(modEventBus);
        }
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CGConfig.commonSpec);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CGConfig.clientSpec);
        modEventBus.addListener(this::gatherData);
        ModCompat.MEKANISM.executeIfInstalled(() -> CompatMekanism::init);
    }

    private void gatherData(GatherDataEvent event) {
        logger.info("gathering data");
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)new RecipeDataProvider(event.getGenerator().getPackOutput(), event.getLookupProvider()));
    }

    @EventBusSubscriber(modid="creategoggles", bus=EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void enqueueIMC(InterModEnqueueEvent event) {
            if (ModCompat.MEKANISM.isLoaded()) {
                MekanismIMC.addMekaSuitHelmetModules((Holder[])new Holder[]{CGModules.GOGGLE_MODULE});
            }
        }
    }
}

